using System;
using Server;
using Server.Misc;
using Server.Items;
using System.Collections;
using System.Collections.Generic;

namespace Server.Mobiles
{
	public class FireFury : BaseCreature
	{
		public override bool DeleteCorpseOnDeath { get { return Summoned; } }
		public override double DispelDifficulty { get { return 70.0; } }
		public override double DispelFocus { get { return 20.0; } }
		public override bool BleedImmune{ get{ return true; } }
		public override bool AlwaysMurderer { get { return true; } }

		[Constructable]
		public FireFury() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a fire fury";
			Body = 0x33;
			Hue = 0x4001;

			SetStr( 500, 580 );
			SetDex( 150, 200 );
			SetInt( 100 );

			SetHits( 700, 800 );
			SetStam( 250 );
			SetMana( 0 );

			SetDamage( 15, 20 );

			SetDamageType( ResistanceType.Fire, 90 );
			SetDamageType( ResistanceType.Physical, 10 );
			
			SetResistance( ResistanceType.Physical, 100 );
			SetResistance( ResistanceType.Fire, 100 );
			SetResistance( ResistanceType.Cold, 10 );
			SetResistance( ResistanceType.Poison, 100 );
			SetResistance( ResistanceType.Energy, 100 );
			
			SetSkill( SkillName.Wrestling, 130.0 );
			SetSkill( SkillName.MagicResist, 70.0 );
			SetSkill( SkillName.Tactics, 150.0 );

			Fame = 6000;
			Karma = 580;

			ControlSlots = 1;
		}
		
		public override void GenerateLoot()
		{
			if ( !Summoned )
			{
				AddLoot( LootPack.UltraRich );
			}
		}

		public override void MoveToWorld( Point3D loc, Map map )
		{
			base.MoveToWorld( loc, map );
			Timer.DelayCall( TimeSpan.FromSeconds( 0.1 ), DoEffects );
		}

		public void DoEffects()
		{
			FixedParticles( 6581, 10, 180, 0x2543, 0, 0, EffectLayer.Waist );
			PlaySound( 0x5CF );
			PlaySound( 477 );

			if( Alive && !Deleted )
			{
				Timer.DelayCall( TimeSpan.FromSeconds( 7.0 ), DoEffects );
				
				if ( !Summoned && !Blessed )
				{
					ArrayList targets = Utilitky.GetTargets( this, 12, true );
					
					for (int i = 0; i < targets.Count; ++i)
					{
						Mobile m = (Mobile)targets[i];
						
						if ( m == null || m.Deleted )
							continue;
						
						m.RevealingAction();
						m.PlaySound(0x1E5);
						this.MovingParticles( m, 0x36E4, 5, 0, false, true, 3006, 4006, 0 );
						
						int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage( Utility.RandomMinMax( 10, 30 ), m );
						
						if ( m is Xanthos.Interfaces.IEvoCreature )
							auradamage *= 2;
						
						m.Hits -= auradamage;
						ISTile5.SendDmgPacket( m, auradamage );
						
						if (m.Hits < 2)
							m.Kill();
					}
				}
			}
		}
		
		public void ConvertToSummon()
		{
			this.SetStr( 150 );
			this.SetDex( 150 );
			this.SetHits( 80 );
			this.SetResistance( ResistanceType.Physical, 90 );
			this.SetResistance( ResistanceType.Fire, 100 );
			this.SetResistance( ResistanceType.Poison, 50 );
			this.SetResistance( ResistanceType.Energy, 50 );
			this.SetSkill( SkillName.Wrestling, 90.0 );
			this.SetSkill( SkillName.Tactics, 100.0 );
			
			this.Fame = 0;
			this.Karma = 0;
			this.Summoned = true;
		}

		public FireFury( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int)0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
